/* (C) 2022 YiRing, Inc. */
package com.yiring.dict.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serial;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.FieldDefaults;

/**
 * 数据字典输出
 *
 * @author Jim
 * @version 0.1
 * 2022/3/25 17:09
 */

@Schema(name = "DictVo")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class DictVo implements Serializable {

    @Serial
    private static final long serialVersionUID = -5041312962732993815L;

    @Schema(description = "id", example = "1")
    String id;

    @Schema(description = "字典名称", example = "性别")
    String name;

    @Schema(description = "字典编号", example = "GENDER")
    String code;

    @Schema(description = "字典描述")
    String description;
}
