/* (C) 2022 YiRing, Inc. */
package com.yiring.websocket.domain;

import com.alibaba.fastjson2.JSONObject;
import java.io.Serial;
import java.io.Serializable;
import java.security.Principal;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldDefaults;
import lombok.experimental.FieldNameConstants;

/**
 * StompPrincipal
 *
 * @author ifzm
 * @version 0.1
 * 2019/9/28 21:28
 */

@Data
@NoArgsConstructor
@AllArgsConstructor
@FieldNameConstants
@FieldDefaults(level = AccessLevel.PRIVATE)
public class StompPrincipal implements Principal, Serializable {

    @Serial
    private static final long serialVersionUID = 5351052642945180737L;

    Type type;
    String user;
    String token;
    String session;
    JSONObject options;

    @Override
    public String getName() {
        return this.session;
    }

    public enum Type {
        /**
         * 游客用户
         */
        GUEST_USER,
        /**
         * 登录用户
         */
        LOGIN_USER,
    }
}
