# Basic API（Template）

> 基于 SpringBoot 构建开箱即用的 API 项目工程

- [开箱即用的 Docker Compose 依赖环境](https://gitlab.yiring.com/runbase/docker-compose-dependencies)

## 开发环境

<!-- prettier-ignore -->

- JDK 17 [版本管理工具](https://github.com/shyiko/jabba)
- NodeJS [下载](https://nodejs.org/zh-cn/)
- IDEA [下载](https://www.jetbrains.com/idea/)
- Navicat Premium [下载](http://www.downcc.com/soft/430673.html)
- RedisDesktopManager [下载](https://github.com/FuckDoctors/rdm-builder)
- Docker(**可选**) [了解](https://www.docker.com/)
- [常用插件清单](./doc/plugins.md)

## 开始

<!-- prettier-ignore -->

- [开发规范说明](./doc/workflow.md)
- [技术栈说明](./doc/technique.md)
- 👉 [实用技巧](./doc/skill.md)

---

## 说明

```shell
# 1. Spotless 依赖下载失败, 可尝试清理本地缓存
npm cache clean --force
```

## TODO

<!-- prettier-ignore -->

- [x] 完成项目构建，开发文档编写
- [x] [conventional-changelog](https://www.cnblogs.com/mengfangui/p/12634845.html)
- [x] 用户及权限模块（目录/菜单/按钮）
- [x] WebSocket 模块
- [x] 通用字典管理模块
- [x] 通用文件上传模块，支持对图片/PDF/MP3/MP4 等文件进行预处理
- [x] XXL-JOB 定时任务模块
- [x] 大文件分片上传
- [x] 更合理的模块拆分，更好的模块解耦
- [x] jasypt 配置加密（生产环境应使用环境变量注入）[引用说明](https://www.cnblogs.com/larrydpk/p/12037857.html)
- [ ] 文件上传扩展支持本地、MinIO、阿里云 OSS、腾讯云 COS 等 [x-file-storage](https://github.com/dromara/x-file-storage)
