/* (C) 2024 YiRing, Inc. */
package com.yiring.app.job;

import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import com.yiring.common.annotation.UptimePush;
import com.yiring.common.core.UptimeNotice;
import com.yiring.common.util.XxlJobUtil;
import java.util.Random;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author Jim
 */
@SuppressWarnings("unused")
@Slf4j
@Component
@RequiredArgsConstructor
public class TestJob {

    //    final Retriever retriever;
    //
    //    /**
    //     * 一个使用 Retriever + @UptimePush 双链路重试的定时任务示例
    //     */
    //    @UptimePush(
    //        key = "BiCC4Jgoa5",
    //        group = "Test",
    //        name = "[TestScheduled] 测试任务调度",
    //        retryCount = 3,
    //        retryStatus = Uptime.Status.UP
    //    )
    //    @Scheduled(fixedDelay = 5, timeUnit = TimeUnit.SECONDS, initialDelay = 60)
    //    public void testScheduled() {
    //        String time = LocalDateTime.now().format(DateFormatter.DATE_TIME);
    //        log.info("TestScheduled: {}", time);
    //
    //        Random random = new Random();
    //        int randomCount = random.nextInt(10);
    //        String result = retriever.execute(
    //            ctx -> {
    //                if (ctx.getRetryCount() > randomCount) {
    //                    return "OK";
    //                }
    //
    //                throw new UptimeException("[TestScheduled] test err: " + time);
    //            },
    //            Retriever::defaultPolicy
    //        );
    //
    //        log.info("[TestScheduled] result: {}", result);
    //    }

    @SuppressWarnings("unused")
    @UptimePush(key = "BiCC4Jgoa5", group = "Test", name = "[TestNoticeHandler] 测试任务调度")
    @XxlJob("TestNoticeHandler")
    public ReturnT<UptimeNotice> testNoticeHandler() {
        Random random = new Random();
        int randomCount = random.nextInt(10);
        if (randomCount < 5) {
            return XxlJobUtil.fail("fail");
        }

        return XxlJobUtil.success("success");
    }
}
