/* (C) 2024 YiRing, Inc. */
package com.yiring.auth.config;

import java.io.Serial;
import java.io.Serializable;
import lombok.AccessLevel;
import lombok.Data;
import lombok.experimental.FieldDefaults;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * @author Jim
 */
@Data
@FieldDefaults(level = AccessLevel.PRIVATE)
@Configuration("custom.auth.config")
@ConfigurationProperties(prefix = "auth")
public class AuthConfig implements Serializable {

    @Serial
    private static final long serialVersionUID = 2896697722679227230L;

    /**
     * 是否启用验证码校验
     */
    boolean captcha;
}
