/* (C) 2022 YiRing, Inc. */
package com.yiring.auth.vo.permission;

import com.alibaba.fastjson2.JSONObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serial;
import java.io.Serializable;
import java.util.List;
import lombok.*;
import lombok.experimental.FieldDefaults;

/**
 * 菜单输出类
 *
 * @author Jim
 * @version 0.1
 * 2022/3/25 17:09
 */

@JsonInclude(JsonInclude.Include.NON_NULL)
@Schema(name = "MenuVo")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class MenuVo implements Serializable {

    @Serial
    private static final long serialVersionUID = -9139328772148985141L;

    @JsonIgnore
    String id;

    @JsonIgnore
    String pid;

    @Schema(description = "唯一标识", example = "Dashboard")
    String uid;

    @Schema(description = "名称", example = "Dashboard")
    String name;

    @Schema(description = "路径", example = "/dashboard")
    String path;

    @Schema(description = "重定向", example = "/dashboard/workbench")
    String redirect;

    @Schema(description = "组件", example = "LAYOUT")
    String component;

    @Schema(description = "元数据", example = "{\"title\": \"routes.dashboard.dashboard\"}")
    JSONObject meta;

    @Schema(description = "子权限")
    List<MenuVo> children;
}
