/* (C) 2022 YiRing, Inc. */
package com.yiring.auth.vo.role;

import com.yiring.auth.vo.permission.PermissionVo;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serial;
import java.io.Serializable;
import java.util.List;
import lombok.*;
import lombok.experimental.FieldDefaults;

/**
 * 角色响应类
 *
 * @author Jim
 * @version 0.1
 * 2022/3/25 17:09
 */

@Schema(name = "RoleVo")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class RoleVo implements Serializable {

    @Serial
    private static final long serialVersionUID = -9154497137563970840L;

    @Schema(description = "主键", example = "1")
    String id;

    @Schema(description = "标识", example = "admin")
    String uid;

    @Schema(description = "名称", example = "系统管理员")
    String name;

    @Schema(description = "权限")
    List<PermissionVo> permissions;
}
