/* (C) 2022 YiRing, Inc. */
package com.yiring.auth.vo.user;

import com.yiring.auth.vo.role.RoleVo;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serial;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import lombok.*;
import lombok.experimental.FieldDefaults;

/**
 * 用户信息
 *
 * @author ifzm
 * 2022/03/03 10:35
 **/

@Schema(name = "UserInfo")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class UserInfoVo implements Serializable {

    @Serial
    private static final long serialVersionUID = -5319037883240327088L;

    @Schema(description = "主键", example = "1")
    String userId;

    @Schema(description = "手机号", example = "15616260195")
    String mobile;

    @Schema(description = "真实姓名", example = "超级用户")
    String realName;

    @Schema(description = "用户名", example = "admin")
    String username;

    @Schema(description = "介绍", example = "系统管理员")
    String desc;

    @Schema(description = "头像", example = "https://s1.ax1x.com/2022/03/30/qggJH0.jpg")
    String avatar;

    @Schema(description = "角色")
    @Builder.Default
    List<RoleVo> roles = new ArrayList<>(0);

    @Schema(description = "用户主页", example = "/dashboard/workbench")
    String homePath;
}
