/* (C) 2023 YiRing, Inc. */
package com.yiring.common.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 流控注解
 * eg: time = 3, count = 1 表示 3 秒内只能请求一次
 *
 * @author Jim
 * @version 0.1
 * 2023/12/19 15:20
 */
@SuppressWarnings({ "unused" })
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface RateLimiter {
    String DEFAULT_CACHE_KEY = "rate_limit:";

    /**
     * 限流key
     */
    String key() default DEFAULT_CACHE_KEY;

    /**
     * 限流时间，单位秒
     */
    int time() default 5;

    /**
     * 限流次数
     */
    int count() default 10;
}
