/* (C) 2023 YiRing, Inc. */
package com.yiring.common.annotation;

import com.yiring.common.utils.Uptime;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Uptime Kuma 服务健康检查注解, 用于标记需要 Push 类型监控的方法
 *
 * @author Jim
 * @version 0.1
 * 2024/12/19 15:20
 */
@SuppressWarnings({ "unused" })
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface UptimePush {
    String CACHE_PREFIX = "uptime_health_push:";

    /**
     * Push 类型的监控项唯一标识
     * eg: <a href="https://uptime.yiring.com/api/push/BiCC4Jgoa5?status=up&msg=OK&ping=">BiCC4Jgoa5</a> 其中的 BiCC4Jgoa5 就是 key
     */
    String key();

    /**
     * 监控项名称
     */
    String name() default "";

    /**
     * 分组名称
     */
    String group() default "";

    /**
     * 重试次数, 默认为 0 不重试
     */
    int retryCount() default 0;

    /**
     * 重试时的状态标记，默认为 DOWN
     */
    Uptime.Status retryStatus() default Uptime.Status.DOWN;

    /**
     * 重试循环，例如设置重试次数为 5，第五次会真正触发异常上报，然后后续继续出现异常触发重试又会积累 5 次后再次上报
     * 默认不开启，代表当达到重试次数后，不会再走重试逻辑，按照默认的失败机制处理，直到成功一次后再重置
     */
    boolean retryLoop() default false;
}
