/* (C) 2021 YiRing, Inc. */
package com.yiring.common.constant;

import java.time.format.DateTimeFormatter;
import lombok.experimental.UtilityClass;

/**
 * 初始化一下常用的日期格式化规则
 *
 * @author ifzm
 * @version 0.1
 * 2019/3/22 14:08
 */

@UtilityClass
public class DateFormatter {

    /**
     * DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")
     */
    public final DateTimeFormatter DATE_TIME = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    /**
     * DateTimeFormatter.ofPattern("yyyy-MM-dd")
     */
    public final DateTimeFormatter DATE = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    /**
     * DateTimeFormatter.ofPattern("HH:mm:ss")
     */
    public final DateTimeFormatter TIME = DateTimeFormatter.ofPattern("HH:mm:ss");
}
