/* (C) 2022 YiRing, Inc. */
package com.yiring.common.domain;

import com.yiring.common.snowflake.SnowflakeIdGenerator;
import jakarta.persistence.Column;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import java.time.LocalDateTime;
import lombok.*;
import lombok.experimental.FieldDefaults;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.ParamDef;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

/**
 * 基础表抽象类
 *
 * @author Jim
 * @version 0.1
 * 2022/4/17 12:11
 */

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@SuperBuilder(toBuilder = true)
@FieldNameConstants
@FieldDefaults(level = AccessLevel.PRIVATE)
@FilterDef(name = "deletedFilter", parameters = @ParamDef(name = "isDeleted", type = Boolean.class))
@Filter(name = "deletedFilter", condition = "deleted = :isDeleted")
@EntityListeners(AuditingEntityListener.class)
@MappedSuperclass
public class BasicEntity {

    @Comment("主键")
    @Id
    @SnowflakeIdGenerator
    String id;

    @Comment("创建人")
    @CreatedBy
    String createBy;

    @Comment("创建时间")
    @CreatedDate
    LocalDateTime createTime;

    @Comment("修改人")
    @LastModifiedBy
    String updateBy;

    @Comment("最后修改时间")
    @LastModifiedDate
    LocalDateTime updateTime;

    @Builder.Default
    @Comment("删除时间")
    @Column(columnDefinition = "bool default false", nullable = false)
    Boolean deleted = Boolean.FALSE;

    public interface Where {
        String EXIST = " deleted = false ";

        String DELETE_SET = " set deleted = true ";

        String WHERE_ID = " where id = ? ";
    }
}
