/* (C) 2022 YiRing, Inc. */
package com.yiring.common.validation;

import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import jakarta.validation.Constraint;
import jakarta.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * 枚举参数校验
 *
 * @author Jim
 * @version 0.1
 * 2022/9/29 16:04
 */

@Documented
@Retention(value = RUNTIME)
@Target({ METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER })
@Constraint(validatedBy = { EnumValueValidated.class })
public @interface EnumValue {
    /**
     * 是否需要（true:不能为空，false:可以为空）
     */
    boolean isRequire() default false;

    /**
     * 字符串数组
     */
    String[] strValues() default {};

    /**
     * int数组
     */
    int[] intValues() default {};

    /**
     * 枚举类
     */
    Class<?>[] enumClass() default {};

    String message() default "所传参数不在允许的值范围内";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};

    @Target({ METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER, TYPE_USE })
    @Retention(RUNTIME)
    @Documented
    @interface List {
        EnumValue[] value();
    }
}
