/* (C) 2021 YiRing, Inc. */
package com.yiring.common.aspect;

import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

/**
 * XxlJob 注解切面
 *
 * @author ifzm
 * @version 0.1
 */

@Slf4j
@Aspect
@Component
public class XxlJobAspect {

    @Around("@annotation(xxlJob)")
    public Object around(ProceedingJoinPoint point, XxlJob xxlJob) throws Throwable {
        try {
            return point.proceed();
        } catch (Exception e) {
            log.error("[XxlJob] {}, Execute Error: {}", xxlJob.value(), e.getMessage(), e);
            throw e;
        }
    }
}
