/* (C) 2023 YiRing, Inc. */
package com.yiring.common.service.impl;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.yiring.common.core.Minio;
import com.yiring.common.service.FileManageService;
import com.yiring.common.service.UploadProcessService;
import java.io.InputStream;
import lombok.Cleanup;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

/**
 * 文件管理服务实现
 *
 * @author Jim
 * @version 0.1
 * 2023/1/29 16:22
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class FileManageServiceImpl implements FileManageService {

    final Minio minio;
    final UploadProcessService service;

    @Override
    public String upload(MultipartFile file) throws Exception {
        // 获取文件名信息
        String filename = file.getOriginalFilename();
        if (StrUtil.isBlank(filename)) {
            throw new RuntimeException("上传文件名不能为空");
        }

        // 获取文件信息以及默认存储地址
        String uuid = IdUtil.fastSimpleUUID();
        String object = minio.buildUploadPath(filename, "", uuid);

        // 预处理（默认不做任何处理，具体逻辑需自行在外部实现）
        object = service.handle(object, file);

        // 上传原文件(如果是转换成了 m3u8 hls 文件则不保存原文件)
        String suffix = ".m3u8";
        if (filename.endsWith(suffix) || !object.endsWith(suffix)) {
            @Cleanup
            InputStream stream = file.getInputStream();
            minio.putObject(stream, file.getContentType(), object);
        }

        return minio.getDefaultURI(object);
    }
}
