/* (C) 2021 YiRing, Inc. */
package com.yiring.common.jackson;

import com.fasterxml.jackson.annotation.JacksonAnnotationsInside;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.lang.annotation.*;

/**
 * Jackson Mapping 序列化
 *
 * @author Jim
 * @version 0.1
 * 2021/10/15 18:05
 */

@Target({ ElementType.FIELD, ElementType.ANNOTATION_TYPE })
@Retention(RetentionPolicy.RUNTIME)
@JacksonAnnotationsInside
@JsonSerialize(using = ObjectMappingSerializer.class)
@Documented
public @interface MappingSerialize {
    /**
     * 处理简单 Mapping 数据字典转换输出，常用于枚举数据处理
     * eg: @MappingSerialize(mapping = "0:女,1:男")
     */
    String mapping();
}
