/* (C) 2023 YiRing, Inc. */
package com.yiring.dict.domain;

import static com.yiring.dict.domain.Dict.TABLE_NAME;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.yiring.common.domain.BasicEntity;
import jakarta.persistence.*;
import java.io.Serial;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import lombok.*;
import lombok.experimental.FieldDefaults;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.SQLDelete;

/**
 * 字典
 *
 * @author Jim
 * @version 0.1
 * 2023/1/20 13:58
 */

@Getter
@Setter
@SuperBuilder(toBuilder = true)
@NoArgsConstructor
@AllArgsConstructor
@FieldNameConstants
@FieldDefaults(level = AccessLevel.PRIVATE)
@SQLDelete(sql = Category.DELETE_SQL + BasicEntity.Where.WHERE_ID)
//@SQLDeleteAll(sql = Category.DELETE_SQL)
@Entity
@Table(
    name = TABLE_NAME,
    indexes = {
        @Index(columnList = BasicEntity.Fields.deleted),
        @Index(columnList = Dict.Fields.name),
        @Index(columnList = Dict.Fields.code),
    },
    uniqueConstraints = { @UniqueConstraint(columnNames = { Dict.Fields.code, BasicEntity.Fields.deleted }) }
)
@Comment("数据字典")
public class Dict extends BasicEntity implements Serializable {

    public static final String TABLE_NAME = "SYS_DICT";
    public static final String DELETE_SQL = "update " + TABLE_NAME + BasicEntity.Where.DELETE_SET;

    @Serial
    private static final long serialVersionUID = -6780729527484051504L;

    @Comment("字典名称")
    @Column(nullable = false)
    String name;

    @Comment("字典编号")
    @Column(nullable = false)
    String code;

    @Comment("字典描述")
    String description;

    @Comment("是否禁用")
    @Column(columnDefinition = "bool default false", nullable = false)
    Boolean disabled;

    @JsonIgnore
    @Builder.Default
    @Comment("字典选项集合")
    @OneToMany(cascade = CascadeType.ALL, mappedBy = "dict")
    List<DictItem> items = new ArrayList<>(0);
}
