/* (C) 2022 YiRing, Inc. */
package com.yiring.dict.param;

import com.yiring.common.validation.group.Group;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.io.Serial;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.FieldDefaults;

/**
 * 数据字典选项参数
 *
 * @author Jim
 * @version 0.1
 * 2022/3/25 17:09
 */

@Schema(name = "DictItemParam")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class DictItemParam implements Serializable {

    @Serial
    private static final long serialVersionUID = -4045504997838271449L;

    @Parameter(description = "id", example = "1")
    @NotBlank(groups = { Group.Edit.class })
    String id;

    @Parameter(description = "字典 ID", example = "1")
    @NotBlank
    String dictId;

    @Parameter(description = "字典选项名称", example = "男")
    @NotBlank
    String name;

    @Parameter(description = "字典选项值", example = "1")
    @NotBlank
    String value;

    @Parameter(description = "字典选项描述")
    String description;

    @Parameter(description = "字典选项排序序号")
    Integer serial;

    @Parameter(description = "是否禁用", example = "false")
    @NotNull
    Boolean disabled;
}
