/* (C) 2024 YiRing, Inc. */
package com.yiring.websocket.domain;

import java.io.Serial;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.FieldDefaults;
import lombok.experimental.FieldNameConstants;

/**
 * @author Jim
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@FieldNameConstants
@FieldDefaults(level = AccessLevel.PRIVATE)
public class Reply implements Serializable {

    @Serial
    private static final long serialVersionUID = -8707725963947081302L;

    /**
     * 从哪个 @MessageMapping 过来的响应
     */
    String from;

    /**
     * 响应的数据
     */
    Object data;
}
